/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.parameter;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class SodiumParameters
extends Parameters {
    private final AlphaTest cutoutAlpha;
    private final AlphaTest defaultAlpha;
    public final ShaderAttributeInputs inputs;
    public final float positionScale;
    public final float positionOffset;
    public final float textureScale;
    private final Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap;
    public AlphaTest alpha;

    public SodiumParameters(Patch patch, AlphaTest alphaTest, AlphaTest alphaTest2, ShaderAttributeInputs shaderAttributeInputs, float f, float f2, float f3, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        super(patch);
        this.cutoutAlpha = alphaTest;
        this.defaultAlpha = alphaTest2;
        this.inputs = shaderAttributeInputs;
        this.positionScale = f;
        this.positionOffset = f2;
        this.textureScale = f3;
        this.textureMap = object2ObjectMap;
        this.alpha = alphaTest2;
    }

    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.textureMap;
    }

    public void setAlphaFor(PatchShaderType patchShaderType) {
        this.alpha = patchShaderType == PatchShaderType.FRAGMENT_CUTOUT ? this.cutoutAlpha : this.defaultAlpha;
    }

    public boolean hasCutoutAlpha() {
        return this.cutoutAlpha != null;
    }

    @Override
    public AlphaTest getAlphaTest() {
        return this.alpha;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.cutoutAlpha == null ? 0 : this.cutoutAlpha.hashCode());
        n = 31 * n + (this.defaultAlpha == null ? 0 : this.defaultAlpha.hashCode());
        n = 31 * n + (this.inputs == null ? 0 : this.inputs.hashCode());
        n = 31 * n + Float.floatToIntBits(this.positionScale);
        n = 31 * n + Float.floatToIntBits(this.positionOffset);
        n = 31 * n + Float.floatToIntBits(this.textureScale);
        n = 31 * n + (this.textureMap == null ? 0 : this.textureMap.hashCode());
        n = 31 * n + (this.alpha == null ? 0 : this.alpha.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SodiumParameters sodiumParameters = (SodiumParameters)object;
        if (this.cutoutAlpha == null ? sodiumParameters.cutoutAlpha != null : !this.cutoutAlpha.equals(sodiumParameters.cutoutAlpha)) {
            return false;
        }
        if (this.defaultAlpha == null ? sodiumParameters.defaultAlpha != null : !this.defaultAlpha.equals(sodiumParameters.defaultAlpha)) {
            return false;
        }
        if (this.inputs == null ? sodiumParameters.inputs != null : !this.inputs.equals(sodiumParameters.inputs)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionScale) != Float.floatToIntBits(sodiumParameters.positionScale)) {
            return false;
        }
        if (Float.floatToIntBits(this.positionOffset) != Float.floatToIntBits(sodiumParameters.positionOffset)) {
            return false;
        }
        if (Float.floatToIntBits(this.textureScale) != Float.floatToIntBits(sodiumParameters.textureScale)) {
            return false;
        }
        if (this.textureMap == null ? sodiumParameters.textureMap != null : !this.textureMap.equals(sodiumParameters.textureMap)) {
            return false;
        }
        return !(this.alpha == null ? sodiumParameters.alpha != null : !this.alpha.equals(sodiumParameters.alpha));
    }
}

